unit Unit1;

interface

uses
  //   VCL - 
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls,
  //   
  MyMath2V3, Grids;

type
  TForm1 = class(TForm)
    ComboBoxSFunc: TComboBox;
    EditXBeg: TEdit;
    EditXStep: TEdit;
    ButtonCalculate: TButton;
    ButtonSave: TButton;
    StrGridReport: TStringGrid;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    procedure ButtonCalculateClick(Sender: TObject);
    procedure EditXBegChange(Sender: TObject);
    procedure EditXStepChange(Sender: TObject);
    procedure ButtonSaveClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation
{$R *.dfm}

// ----------------------------------------------------------------
var XBeg  : double;
    XStep : double;
var XArr, YArr, ZArr : array [0..49] of double;  //  50  

// ----------------------------------------------------------------
//        
function ProStrToFloat (RqStr   : string;
                    var RqFloat : double) : boolean;
begin
  Result  := False;     //   
  try
    RqFloat := StrToFloat(RqStr);
    Result  := True;    //   
  except
    ShowMessage('    ');
  end;
end;
// ----------------------------------------------------------------
//        
procedure ShowTabFuncToGrid
         (RqFuncName : string;
          RqReport : TStringGrid;
          RqXArray, RqYArray, RqZArray : array of double);
var Ind : integer;
begin
   RqReport.RowCount := 1;           //  Grid
   RqReport.ColCount := 3;
   //  
   RqReport.Cells[0,0] := 'X';
   RqReport.Cells[1,0] := RqFuncName;
   RqReport.Cells[2,0] := '..';
   //    Grid
   RqReport.RowCount := Length(RqXArray)+ 1;
   for Ind := Low(RqXArray) to High(RqXArray) do
   begin
     RqReport.Cells[0,Ind+1] := FloatToStr(RqXArray[Ind]);
     RqReport.Cells[1,Ind+1] := FloatToStr(RqYArray[Ind]);
     RqReport.Cells[2,Ind+1] := FloatToStr(RqZArray[Ind]);
   end;
end;

// ----------------------------------------------------------------
//       
procedure MakeXArray (RqXBeg, RqStep : double; var RqXArray : array of double);
var Ind : integer;
begin
  if Length(RqXArray) > 1
  then begin
     RqXArray[Low(RqXArray)] := RqXBeg;
     for Ind := Low(RqXArray) to High(RqXArray) - 1 do
     begin
       RqXArray[Ind + 1]:= RqXArray[Ind] + RqStep;
     end;
  end;
end;

// ----------------------------------------------------------------
//          
procedure CalculateAndShowTaylorFunc
         (RqFuncName : string;
          RqReport   : TStringGrid;
          RqFunc     : char;
          RqXArray   : array of double;
          var RqYArray, RqZArray : array of double);
begin
  // --------------------------------------
  // RqFunc := 'E';    EXP
  // RqFunc := 'S';    SIN (RqX  );
  // RqFunc := 'C';    COS (RqX  );
  // RqFunc := 'I';     SI (RqX  );
  //   Y   ,   Z 
  //         
  //     Delphi .
  //  , Y, Z    .
  TaylorFuncToYArray (RqFunc, RqXArray, RqYArray, RqZArray);
  // --------------------------------------
  ShowTabFuncToGrid(RqFuncName, RqReport, RqXArray, RqYArray, RqZArray);
end;

// ----------------------------------------------------------------
//        
procedure SaveReportToFile(RqXArray, RqYArray, RqZArray : array of double);
var Ind    : integer;
    WStr   : string;
    Report : TStrings;
begin
   Report := TStringList.Create;
   try
      for Ind := Low(RqXArray) to High(RqXArray) do
      begin
        //   6,    4 
        WStr := FloatToStrF(RqXArray[Ind], ffFixed, 6,4);
        //   9,   3
        WStr := WStr + #09 + FloatToStrF(RqYArray[Ind], ffExponent, 9,3);
        WStr := WStr + #09 + FloatToStrF(RqZArray[Ind], ffExponent, 9,3);
        Report.Add(WStr);
      end;
      Report.SaveToFile('.\FunctionValueTable.txt');
   finally
      Report.Free;
   end;
end;
// ----------------------------------------------------------------
//      
procedure TForm1.ButtonCalculateClick(Sender: TObject);
begin
  if ProStrToFloat(EditXBeg.Text, XBeg) and
     ProStrToFloat(EditXStep.Text, XStep)
  then begin
    MakeXArray (XBeg, XStep, XArr);
    case ComboBoxSFunc.ItemIndex of
    0: CalculateAndShowTaylorFunc
          (ComboBoxSFunc.Text, StrGridReport, 'E', XArr, YArr, ZArr);
    1: CalculateAndShowTaylorFunc
          (ComboBoxSFunc.Text, StrGridReport, 'S', XArr, YArr, ZArr);
    2: CalculateAndShowTaylorFunc
          (ComboBoxSFunc.Text, StrGridReport, 'C', XArr, YArr, ZArr);
    3: CalculateAndShowTaylorFunc
          (ComboBoxSFunc.Text, StrGridReport, 'I', XArr, YArr, ZArr);
    end;
  end;
end;
// ----------------------------------------------------------------
//      
procedure TForm1.EditXBegChange(Sender: TObject);
begin
  XBeg := 0;
  ProStrToFloat(EditXBeg.Text, XBeg);
end;

//      
procedure TForm1.EditXStepChange(Sender: TObject);
begin
 XStep := 0.1;
 ProStrToFloat(EditXStep.Text, XStep);
end;
// ----------------------------------------------------------------
//       
procedure TForm1.ButtonSaveClick(Sender: TObject);
begin
   SaveReportToFile(XArr, YArr, ZArr);
end;
// ----------------------------------------------------------------
// ----------------------------------------------------------------
end.
